package com.mtocommunity.pc3;

import java.util.Arrays;
import java.util.Comparator;

public class Competencia {
    private Velocista[] velocistas;
    private int contador;

    public Competencia() {
        contador = 0;
        velocistas = new Velocista[]{};
    }

    public void agregarVelocista(Velocista velocista) {
        if(velocistas.length >= 10) return;

        velocistas = Arrays.copyOf(velocistas, velocistas.length + 1);
        velocistas[velocistas.length - 1] = velocista;
    }

    public String reportarTabla() {
        StringBuilder reporte = new StringBuilder();

        Arrays.sort(velocistas, Comparator.comparingDouble(Velocista::calcularPromedio));

        for (int i = 0; i < velocistas.length; i++) {
            Velocista velocista = velocistas[i];

            reporte.append(i + 1);
            reporte.append(". ");
            reporte.append(velocista);
            reporte.append("\n");
        }

        return reporte.toString();
    }

    public Velocista[] getVelocistas() {
        return velocistas;
    }

    public void setVelocistas(Velocista[] velocistas) {
        if(velocistas.length <= 10) {
            this.velocistas = velocistas;
        }
    }

    public int getContador() {
        return contador;
    }

    public void setContador(int contador) {
        this.contador = contador;
    }
}
