package com.mtocommunity.pc3;

public class CompresorCadena {
    public String comprimir(String cadena) {
        StringBuilder nuevaCadena = new StringBuilder();
        char letraAnterior = '=';
        char letraActual;
        int contador = 1;

        for (int i = 0; i < cadena.length(); i++) {
            letraActual = cadena.charAt(i);

            if(letraAnterior == '=') {
                letraAnterior = letraActual;
                continue;
            }

            if(letraActual == letraAnterior) {
                contador++;
                // Si no es el último carácter continua la siguiente iteración
                if(i != cadena.length() - 1) continue;
            }

            if(contador > 2) {
                nuevaCadena.append(letraAnterior);
                nuevaCadena.append(contador);
            } else {
                for (int j = 0; j < contador; j++) {
                    nuevaCadena.append(letraAnterior);
                }
            }
            contador = 1;
            letraAnterior = letraActual;
        }

        return nuevaCadena.toString();
    }

    public String descomprimir(String cadena) {
        StringBuilder nuevaCadena = new StringBuilder();
        char letraAnterior = '=';
        char letraActual;

        for (int i = 0; i < cadena.length(); i++) {
            letraActual = cadena.charAt(i);

            if(letraAnterior == '=') {
                letraAnterior = letraActual;
            }

            /*
            0 - 48
            1 - 49
            2 - 50
            3 - 51
            4 - 52
            5 - 53
            6 - 54
            7 - 55
            8 - 56
            9 - 57
             */
            if(letraActual >= 48 && letraActual <= 57) {
                int contador = letraActual - 48;
                for (int j = 0; j < contador - 1; j++) {
                    nuevaCadena.append(letraAnterior);
                }
                letraAnterior = '=';
            } else {
                nuevaCadena.append(letraActual);
                letraAnterior = letraActual;
            }
        }

        return nuevaCadena.toString();
    }

    public static void main(String[] args) {
        CompresorCadena compresorCadena = new CompresorCadena();
        String texto1 = "jaavvvaaaaa";
        String texto2 = "go7l3";

        System.out.println(texto1);
        System.out.println(texto2);
        System.out.println("--------");

        String prueba1 = compresorCadena.comprimir(texto1);
        String prueba2 = compresorCadena.descomprimir(prueba1);
        String prueba3 = compresorCadena.descomprimir(texto2);
        String prueba4 = compresorCadena.comprimir(prueba2);

        System.out.println(prueba1);
        System.out.println(prueba2);
        System.out.println(prueba3);
        System.out.println(prueba4);
    }
}
