package com.mtocommunity.repaso.ejercicio1;

import java.util.Arrays;
import java.util.Date;

public class Cliente {
    private String dni;
    private String apellidos;
    private String nombres;
    private String correoElectronico;
    private String direccion;
    public Date fechaNacimiento;
    private CuentaBancaria[] cuentasBancarias;

    public Cliente() {
    }

    public Cliente(String dni, String apellidos, String nombres, String correoElectronico, String direccion, Date fechaNacimiento, CuentaBancaria[] cuentasBancarias) {
        this.dni = dni;
        this.apellidos = apellidos;
        this.nombres = nombres;
        this.correoElectronico = correoElectronico;
        this.direccion = direccion;
        this.fechaNacimiento = fechaNacimiento;
        this.cuentasBancarias = cuentasBancarias;
    }

    public Cliente(String dni, String apellidos, String nombres, String correoElectronico, String direccion, Date fechaNacimiento, CuentaBancaria cuenta1, CuentaBancaria cuenta2, CuentaBancaria cuenta3, CuentaBancaria cuenta4, CuentaBancaria cuenta5) {
        this.dni = dni;
        this.apellidos = apellidos;
        this.nombres = nombres;
        this.correoElectronico = correoElectronico;
        this.direccion = direccion;
        this.fechaNacimiento = fechaNacimiento;
        this.cuentasBancarias = new CuentaBancaria[]{cuenta1, cuenta2, cuenta3, cuenta4, cuenta5};
    }

    public void agregarCuenta(CuentaBancaria nuevaCuenta) throws IndexOutOfBoundsException {
        if(cuentasBancarias.length == 5) {
            throw new ArrayIndexOutOfBoundsException("Este cliente ya tiene 5 cuentas bancarias.");
        }

        cuentasBancarias = Arrays.copyOf(cuentasBancarias, cuentasBancarias.length + 1);
        cuentasBancarias[cuentasBancarias.length - 1] = nuevaCuenta;
    }

    @Override
    public String toString() {
        return String.format("%s - %s, %s (%s) - [%d]", dni, apellidos, nombres, correoElectronico, cuentasBancarias.length);
    }

    public void mostrarCuentas() {
        for (int i = 0; i < cuentasBancarias.length; i++) {
            System.out.println(cuentasBancarias[i]);
        }
    }

    public String getDni() {
        return dni;
    }

    public void setDni(String dni) {
        this.dni = dni;
    }

    public String getApellidos() {
        return apellidos;
    }

    public void setApellidos(String apellidos) {
        this.apellidos = apellidos;
    }

    public String getNombres() {
        return nombres;
    }

    public void setNombres(String nombres) {
        this.nombres = nombres;
    }

    public String getCorreoElectronico() {
        return correoElectronico;
    }

    public void setCorreoElectronico(String correoElectronico) {
        this.correoElectronico = correoElectronico;
    }

    public String getDireccion() {
        return direccion;
    }

    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    public CuentaBancaria[] getCuentasBancarias() {
        return cuentasBancarias;
    }

    public void setCuentasBancarias(CuentaBancaria[] cuentasBancarias) {
        this.cuentasBancarias = cuentasBancarias;
    }
}
