package com.mtocommunity.repaso.ejercicio2;

import java.util.Arrays;

public class OperadorArreglos {
    public static int[] sumarConjuntos(int[] arreglo1, int[] arreglo2) {
        int[] nuevoArreglo = new int[]{};

        for (int i = 0; i < arreglo1.length; i++) {
            // Si el numero no existe en el nuevo arreglo lo añade
            if(!contiene(nuevoArreglo, arreglo1[i])) {
                nuevoArreglo = Arrays.copyOf(nuevoArreglo, nuevoArreglo.length + 1);
                nuevoArreglo[nuevoArreglo.length - 1] = arreglo1[i];
            }
        }

        for (int i = 0; i < arreglo2.length; i++) {
            // Si el numero no existe en el nuevo arreglo lo añade
            if(!contiene(nuevoArreglo, arreglo2[i])) {
                nuevoArreglo = Arrays.copyOf(nuevoArreglo, nuevoArreglo.length + 1);
                nuevoArreglo[nuevoArreglo.length - 1] = arreglo2[i];
            }
        }

        return nuevoArreglo;
    }

    public static int[] restarConjuntos(int[] arreglo1, int[] arreglo2) {
        int[] nuevoArreglo = new int[]{};

        for (int i = 0; i < arreglo1.length; i++) {
            int numero = arreglo1[i];
            // El numero no esta en arreglo2 y todavia no fue agregado al nuevo arreglo
            if(!contiene(arreglo2, numero) && !contiene(nuevoArreglo, numero)) {
                nuevoArreglo = Arrays.copyOf(nuevoArreglo, nuevoArreglo.length + 1);
                nuevoArreglo[nuevoArreglo.length - 1] = numero;
            }
        }

        return nuevoArreglo;
    }

    public static int[] intersectarConjuntos(int[] arreglo1, int[] arreglo2) {
        int[] nuevoArreglo = new int[]{};

        for (int i = 0; i < arreglo1.length; i++) {
            int numero = arreglo1[i];

            if(contiene(arreglo2, numero) && !contiene(nuevoArreglo, numero)) {
                nuevoArreglo = Arrays.copyOf(nuevoArreglo, nuevoArreglo.length + 1);
                nuevoArreglo[nuevoArreglo.length - 1] = numero;
            }
        }

        return nuevoArreglo;
    }

    private static boolean contiene(int[] arreglo, int numero) {
        for (int i = 0; i < arreglo.length; i++) {
            if(arreglo[i] == numero) return true;
        }
        return false;
    }
}
