package com.mtocommunity.repaso.ejercicio3;

/*
Tablero 3x3
Un espacio vacio se representa con un 0
La X se representa con un 1
La O se representa con un 2
 */
public class TikTakToe {
    private int[][] tablero;

    public TikTakToe() {
        tablero = new int[3][3];
    }

    /*
    Si se pudo colocar devuelve true
     */
    public boolean ponerX(int x, int y) {
        int actualValue = tablero[x][y];
        if(actualValue != 0) return false;
        tablero[x][y] = 1;
        return true;
    }

    /*
    Si se pudo colocar devuelve true
     */
    public boolean ponerO(int x, int y) {
        int actualValue = tablero[x][y];
        if(actualValue != 0) return false;
        tablero[x][y] = 2;
        return true;
    }

    /*
    Si devuelve 0 es que no hay ganador aún
    Si devuelve 1 el ganador es X
    Si devuelve 2 el ganador es O
    Si devuelve 3 es que hay un empate
     */
    public int obtenerGanador() {
        if(existenLugares()) return 0;

        // Ganador linea vertical X
        if(tablero[0][1] == 1 && tablero[0][2] == 1 && tablero[0][3] == 1) return 1;
        if(tablero[1][1] == 1 && tablero[1][2] == 1 && tablero[1][3] == 1) return 1;
        if(tablero[2][1] == 1 && tablero[2][2] == 1 && tablero[2][3] == 1) return 1;

        // Ganador linea horizontal X
        if(tablero[0][0] == 1 && tablero[1][0] == 1 && tablero[2][0] == 1) return 1;
        if(tablero[0][1] == 1 && tablero[1][1] == 1 && tablero[2][1] == 1) return 1;
        if(tablero[0][2] == 1 && tablero[1][2] == 1 && tablero[2][2] == 1) return 1;

        // Ganador linea aspa X
        if(tablero[0][0] == 1 && tablero[1][1] == 1 && tablero[2][2] == 1) return 1;
        if(tablero[2][0] == 1 && tablero[1][1] == 1 && tablero[0][2] == 1) return 1;

        // Ganador linea vertical O
        if(tablero[0][1] == 2 && tablero[0][2] == 2 && tablero[0][3] == 2) return 2;
        if(tablero[1][1] == 2 && tablero[1][2] == 2 && tablero[1][3] == 2) return 2;
        if(tablero[2][1] == 2 && tablero[2][2] == 2 && tablero[2][3] == 2) return 2;

        // Ganador linea horizontal O
        if(tablero[0][0] == 2 && tablero[1][0] == 2 && tablero[2][0] == 2) return 2;
        if(tablero[0][1] == 2 && tablero[1][1] == 2 && tablero[2][1] == 2) return 2;
        if(tablero[0][2] == 2 && tablero[1][2] == 2 && tablero[2][2] == 2) return 2;

        // Ganador linea aspa O
        if(tablero[0][0] == 2 && tablero[1][1] == 2 && tablero[2][2] == 2) return 2;
        if(tablero[2][0] == 2 && tablero[1][1] == 2 && tablero[0][2] == 2) return 2;

        return 3;
    }

    private boolean existenLugares() {
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                if(tablero[i][j] == 0) return true;
            }
        }
        return false;
    }

    public void restart() {
        tablero = new int[3][3];
    }
}
